<?php

namespace Albedo\SpecialMission\Missions;

use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Database\Eloquent\Model;
use Albedo\SpecialMission\Models\SpecialMission as SpecialMissionModel;

abstract class Mission implements Arrayable
{
    public function __construct(
        protected Model               $model,
        protected SpecialMissionModel $specialMissionModel,
    )
    {
    }

    abstract public function getMaxRealization(): int;

    abstract public function getCurrentRealization(): int;

    public function getModel()
    {
        return $this->model;
    }

    public function getSpecialMission()
    {
        return $this->specialMissionModel;
    }

    public function getPercentageWithSymbol(): string
    {
        return sprintf('%s%%',  number_format(round($this->getPercentage() * 100)));
    }

    public function getPercentage(): string
    {
        return $this->getMaxRealization() > 0
                ? $this->getCurrentRealization() / $this->getMaxRealization()
                : 0;
    }

    public function hasGoalAchieved(): bool
    {
        return $this->getCurrentRealization() >= $this->getMaxRealization();
    }

    public function getTimeLeft(): int
    {
        $end = $this->getSpecialMission()->end;
        $showTimeLeft = $this->getSpecialMission()->show_time_left;

        if ($showTimeLeft === true && !is_null($end)) {
            return (int)now()->diffInMilliseconds($this->getSpecialMission()->end);
        }

        return 0;
    }

    public function getProgressBarTitle(): string
    {
        return 'xxx';
    }

    public function getProgressBarUnitRealization(): string
    {
        return 'xx.';
    }
    public function toArray(): array
    {
        return [
            'id' => $this->getSpecialMission()->id,
            'name' => $this->getSpecialMission()->name,
            'description' => $this->getSpecialMission()->description,
            'image' => $this->getSpecialMission()->image,
            'start' => $this->getSpecialMission()->start,
            'end' => $this->getSpecialMission()->end,
            'goal_achieved' => $this->hasGoalAchieved(),
            'time_left' => $this->getTimeLeft(),
            'show_progress_bar' => $this->getSpecialMission()->show_progress_bar,
            'progress_bar' => [
                'title' => $this->getProgressBarUnitRealization(),
                'unit_realization' => $this->getProgressBarUnitRealization(),
                'max_realization' => $this->getMaxRealization(),
                'current_realization' => $this->getCurrentRealization(),
                'percentage_realization' => $this->getPercentage(),
            ],
        ];
    }

}
