<?php

namespace Albedo\SpecialMission\Console\Commands;

use Albedo\SpecialMission\Enum\SpecialMissionStatus;
use Albedo\SpecialMission\Missions\DoublePointsForMastercardProducts;
use Albedo\SpecialMission\Missions\ExampleMission;
use App\Models\User;
use Illuminate\Console\Command;

class SpecialMissionExampleCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'special-mission:example';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    public const DEMO_NAME = 'Special Mission Example';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        \Albedo\SpecialMission\Models\SpecialMission::create([
            'start' => now()->subWeek()->startOfDay(),
            'end' => now()->addWeek()->endOfDay(),
            'name' => 'Xxxx xxxxx',
            'description' => 'Xxxxxxxxxxxx xxxxx xxxxxxxx xxxxxxxxxxxxxxxxxxxxxxx',
            'image' => url('assets/img/special-missions/example.png'),
            'show_progress_bar' => true,
            'class_name' => ExampleMission::class,
            'status' => SpecialMissionStatus::OPEN,
        ]);
    }
}
