<?php

namespace Albedo\SpecialMission;

use Albedo\SpecialMission\Console\Commands\SpecialMissionExampleCommand;
use Albedo\SpecialMission\Console\Commands\SpecialMissionUpdateCommand;
use Albedo\SpecialMission\Contracts\ParticipantSpecialMission;
use Spatie\LaravelPackageTools\Commands\InstallCommand;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class SpecialMissionProvider extends PackageServiceProvider
{
    public static string $name = 'special-mission';

    public function configurePackage(Package $package): void
    {
        $package->name(static::$name)
            ->hasConfigFile()
            ->hasRoute('special-mission')
            ->hasCommands([
                SpecialMissionExampleCommand::class,
                SpecialMissionUpdateCommand::class,
            ])
            ->hasMigrations([
                '2024_10_16_113320_create_special_missions_table',
                '2024_10_16_122658_create_special_mission_results_table'
            ])
            ->runsMigrations()
            ->hasInstallCommand(function(InstallCommand $command) {
                $command
                    ->publishConfigFile()
                    ->publishAssets()
                    ->publishMigrations()
                    ->copyAndRegisterServiceProviderInApp();
            });
    }

    public function packageBooted(): void
    {
        app()->bind(ParticipantSpecialMission::class, config('special-mission.user_model'));
    }
}
