<?php

namespace Albedo\SpecialMission\Models;

use Albedo\SpecialMission\Enum\SpecialMissionStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class SpecialMissionResult extends Model
{
    use HasFactory;

    protected $guarded = '';

    protected $casts = [
        'max_result' => 'integer',
        'current_result' => 'integer',
    ];

    public function modelable(): MorphTo
    {
        return $this->morphTo();
    }

    public function specialMission()
    {
        return $this->belongsTo(SpecialMission::class);
    }
}
