<?php


namespace Albedo\SpecialMission\Models;

use Albedo\SpecialMission\Enum\SpecialMissionStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Support\Facades\Auth;

class SpecialMission extends Model
{
    use HasFactory;

    protected $guarded = '';

    protected $casts = [
        'start' => 'datetime',
        'end' => 'datetime',
        'status' => SpecialMissionStatus::class,
    ];

    public function specialMissionResults(): HasMany
    {
        return $this->hasMany(SpecialMissionResult::class);
    }

    public function specialMissionResultsByLoggedUser(): HasOne
    {
        return $this->hasOne(SpecialMissionResult::class, 'special_mission_id', 'id')
            ->whereMorphedTo('modelable', Auth::user())
            ->latest('created_at');
    }
}
