<?php

namespace Albedo\SpecialMission\Missions;

use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Database\Eloquent\Model;
use Albedo\SpecialMission\Models\SpecialMission as SpecialMissionModel;

abstract class Mission implements Arrayable
{
    public function __construct(
        protected Model               $model,
        protected SpecialMissionModel $specialMissionModel,
    )
    {
    }

    abstract public function getMaxRealization(): int;

    abstract public function getCurrentRealization(): int;

    public function getModel()
    {
        return $this->model;
    }

    public function getSpecialMission()
    {
        return $this->specialMissionModel;
    }

    public function getName(): string
    {
        return 'Mission example.';
    }

    public function getPercentageWithSymbol(): string
    {
        return sprintf('%s%%',  number_format(round($this->getPercentage() * 100)));
    }

    public function getPercentage(): string
    {
        return $this->getMaxRealization() > 0
                ? $this->getCurrentRealization() / $this->getMaxRealization()
                : 0;
    }

    public function hasGoalAchieved(): bool
    {
        return $this->getCurrentRealization() >= $this->getMaxRealization();
    }

    public function toArray(): array
    {
        return [
            'name' => $this->getName(),
            'max_realization' => $this->getMaxRealization(),
            'current_realization' => $this->getCurrentRealization(),
            'percentage' => $this->getPercentage(),
            'goal_achieved' => $this->hasGoalAchieved(),
        ];
    }

}
