<?php

namespace Albedo\SpecialMission\Http\Controllers;

use _PHPStan_1611a8848\React\Http\Message\Response;
use Albedo\SpecialMission\Http\Resources\SpecialMissionResource;
use Albedo\SpecialMission\Models\SpecialMission;
use Albedo\SpecialMission\Mission;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class SpecialMissionAction extends Controller
{
    /**
     * Handle the incoming request.
     */
    public function __invoke(Request $request)
    {
        $specialMissionModels = SpecialMission::query()
            ->whereDate('start', '<=', now())
            ->whereDate('end', '>=', now())
            ->with('specialMissionResultsByLoggedUser')
            ->get();

        return Response::success(
            data: SpecialMissionResource::collection($specialMissionModels)
        );

    }
}
