<?php

namespace Albedo\SpecialMission\Services;

use Albedo\SpecialMission\Contracts\ParticipantSpecialMission;
use Albedo\SpecialMission\Events\GoalAchievedSpecialMissionEvent;
use Albedo\SpecialMission\Models\SpecialMission;

class SpecialMissionService
{
    public static function make(): self
    {
        return app(self::class);
    }

    public function createOrUpdateMission(ParticipantSpecialMission $participant, SpecialMission $specialMission): void
    {
        $mission = app($specialMission->class_name, [
            'model' => $participant,
            'specialMissionModel' => $specialMission
        ]);

        $specialMissionResultModel = \Albedo\SpecialMission\Models\SpecialMissionResult::query()
            ->firstOrNew([
                'special_mission_id' => $specialMission->id,
                'modelable_type' => $participant->getClass(),
                'modelable_id' => $participant->getId(),
            ], [
                'name' => $mission->getName(),
                'max_result' => $mission->getMaxRealization(),
                'current_result' => $mission->getCurrentRealization(),
                'percentage' => $mission->getPercentage(),
            ]);


        if (!is_null($specialMissionResultModel->goal_achieved)) {
            return;
        }

        $specialMissionResultModel->fill([
            'name' => $mission->getName(),
            'max_result' => $mission->getMaxRealization(),
            'current_result' => $mission->getCurrentRealization(),
            'percentage' => $mission->getPercentage(),
        ]);

        if ($mission->hasGoalAchieved()) {
            $specialMissionResultModel->goal_achieved = now();
            event(new GoalAchievedSpecialMissionEvent($participant, $specialMission));
        }

        $specialMissionResultModel->save();
    }

}
