<?php

namespace Albedo\SpecialMission\Http\Controllers;

use Albedo\SpecialMission\Http\Resources\SpecialMissionResource;
use Albedo\SpecialMission\Models\SpecialMission;
use Albedo\SpecialMission\Mission;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;

class SpecialMissionAction extends Controller
{
    /**
     * Handle the incoming request.
     */
    public function __invoke(Request $request)
    {
        $specialMissionModels = SpecialMission::query()
            ->whereDate('start', '<=', now())
            ->whereDate('end', '>=', now())
            ->with('specialMissionResultsByLoggedUser')
            ->get();

        $result = $specialMissionModels->map(fn(SpecialMission $specialMission) => app($specialMission->class_name, [
            'model' => $request->user(),
            'specialMissionModel' => $specialMission
        ])
            ->toArray());

        return Response::success(
            data: SpecialMissionResource::collection($result)
        );

    }
}
