<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('special_mission_results', function (Blueprint $table) {
                $table->id();
                $table->foreignIdFor(\Albedo\SpecialMission\Models\SpecialMission::class);
                $table->morphs('modelable');
                $table->string('name');
                $table->string('max_result')->default(0);
                $table->string('current_result')->default(0);
                $table->string('percentage')->default(0);
                $table->dateTime('goal_achieved')->nullable();
                $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('special_mission_results');
    }
};
