<?php

namespace Albedo\SpecialMission\Missions;

use Albedo\SpecialMission\Models\SpecialMission as SpecialMissionModel;
use Illuminate\Database\Eloquent\Model;

class ExampleMission extends Mission
{
    protected int $max = 10;

    protected int $current;

    /**
     * @throws Exception
     */
    public function __construct(Model $model, SpecialMissionModel $specialMissionModel)
    {
        parent::__construct($model, $specialMissionModel);

        $this->current = random_int(0,10);
    }

    public function getMaxRealization(): int
    {
        return $this->max;
    }

    public function getCurrentRealization(): int
    {
        return $this->current;
    }
}