<?php

namespace Albedo\SpecialMission\Missions;

use Albedo\SpecialMission\Http\Resources\SpecialMissionResultResource;
use Albedo\SpecialMission\Models\SpecialMissionResult;
use App\Services\DatetimeForHumanService;
use Exception;
use Illuminate\Database\Eloquent\Model;
use Albedo\SpecialMission\Models\SpecialMission as SpecialMissionModel;
use Illuminate\Support\HtmlString;
use Symfony\Component\Console\Helper\ProgressBar;

class DoublePointsForMastercardProducts extends Mission
{
    protected int $max = 0;

    protected int $current = 0;

    /**
     * @throws Exception
     */
    public function __construct(
        Model                             $model,
        SpecialMissionModel               $specialMissionModel,
        protected DatetimeForHumanService $datetimeForHumanService

    )
    {
        parent::__construct($model, $specialMissionModel);
    }

    public function getName(): string
    {
        return 'Zyskaj ekstra punkty w nowej misji specjalnej!';
    }

    public function getDescription(): string
    {
        return new HtmlString('Przed Tobą trzecia misja specjalna, w której każdy punkt za sprzedaż kart liczy się podwójnie!<br>
                                    Nowa misja specjalna trwa od 16 czerwca do 31 lipca 2025 r. Wykorzystaj ten czas maksymalnie i zwiększ swoje szanse w rankingu!<br>
                                    Po zakończeniu okresu weryfikacji transakcyjności (do 31 sierpnia 2025 r.), dodatkowe <strong>1000 punktów</strong> trafi do <strong>TOP 5 banków</strong> w każdej grupie!<br>
                                    Podejmij wyzwanie już teraz!');
    }

    public function getCurrentRealization(): int
    {
        return $this->current;
    }

    public function getMaxRealization(): int
    {
        return 0;
    }

    public function toArray(): array
    {
        return [
            'name' => $this->specialMissionModel->name ?? $this->getName(),
            'description' => $this->specialMissionModel->description ?? $this->getDescription(),
            'time_left' => $this->datetimeForHumanService->getTimeLeft($this->specialMissionModel->end),
            'image' => url('img/special-mission/special-mission.webp'),
            'show_progress_bar' => false,
        ];
    }
}
