<?php

namespace Albedo\SpecialMission\Http\Resources;

use Albedo\SpecialMission\Models\SpecialMission as SpecialMissionModel;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Auth;

class SpecialMissionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $class = app($this->class_name, [
            'model' => $request->user(),
            'specialMissionModel' => $this->resource
        ]);

        return [
            'id' => $this->id,
            'image' => url('storage/' . $this->image),
            'start' => $this->start,
            'end' => $this->end,
            'result' => SpecialMissionResultResource::make($this->whenLoaded('specialMissionResultsByLoggedUser')),
            'progress_bar' => SpecialMissionResultResource::make($this->whenLoaded('specialMissionResultsByLoggedUser')),
            ...$class->toArray(),
        ];
//            'name' => $this->name,
//            'description' => $this->description,
//            'show_progress_bar' => $this->show_progress_bar,
//            'result' => SpecialMissionResultResource::make($this->whenLoaded('specialMissionResultsByLoggedUser')),
//            'progress_bar' => SpecialMissionResultResource::make($this->whenLoaded('specialMissionResultsByLoggedUser'))
    }
}
