<?php

namespace Albedo\SpecialMission\Console\Commands;

use Albedo\SpecialMission\Contracts\ParticipantSpecialMission;
use Albedo\SpecialMission\Models\SpecialMission;
use Albedo\SpecialMission\Services\SpecialMissionService;
use App\Models\User;
use Illuminate\Console\Command;

class SpecialMissionUpdateCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'special-mission:update';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $specialMissions = SpecialMission::all();
        $participants = app(ParticipantSpecialMission::class)->getParticipantsOfSpecialMissions();

        $bar = $this->output->createProgressBar($participants->count());

        $bar->start();

        $participants->each(fn(ParticipantSpecialMission $participant) => $specialMissions
            ->each(function (SpecialMission $specialMission) use ($participant, $bar) {
                SpecialMissionService::make()->createOrUpdateMission($participant, $specialMission);
                 $bar->advance();
            }));

        $bar->finish();
        $this->info(' Special missions updated.');

        return 0;
    }
}
