<?php

namespace Albedo\ScratchCard\Models;

use Albedo\ScratchCard\Contracts\LotteryDrawContract;
use Albedo\ScratchCard\Database\factories\ScratchCardTypeFactory;
use Albedo\ScratchCard\Enums\ScratchCardReasonType;
use Albedo\ScratchCard\GateLotteryByScratchCardTypeGenerator;
use Albedo\ScratchCard\GuaranteedPrizeDuelGenerator;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class ScratchCardType extends Model implements HasMedia
{
    use HasFactory, InteractsWithMedia;

    protected $guarded = [];

    public function color(): BelongsTo
    {
        return $this->belongsTo(ScratchCardColor::class, 'scratch_card_color_id');
    }

    public function reason(): BelongsTo
    {
        return $this->belongsTo(ScratchCardReason::class, 'scratch_card_reason_id');
    }

    public function getPrizeGenerator(): LotteryDrawContract
    {
        return match ($this->reason->type) {
            ScratchCardReasonType::GATE_PRIZE => new GateLotteryByScratchCardTypeGenerator($this->reason),
            ScratchCardReasonType::GUARANTED_PRIZE => new GuaranteedPrizeDuelGenerator(),
            ScratchCardReasonType::LOTTERY => new LotteryByScratchCardTypeGenerator($this->reason),
        };
    }

    /**
     * Create a new factory instance for the model.
     */
    protected static function newFactory(): Factory
    {
        return ScratchCardTypeFactory::new();
    }

    public function registerMediaCollections(): void
    {
        $this->addMediaCollection('image')
            ->singleFile();
    }
}
