<?php

namespace Albedo\ScratchCard\Models;

use Albedo\ScratchCard\Database\factories\ScratchCardColorFactory;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ScratchCardColor extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function types(): HasMany
    {
        return $this->hasMany(ScratchCardType::class, 'scratch_card_color_id');
    }

    /**
     * Create a new factory instance for the model.
     */
    protected static function newFactory(): Factory
    {
        return ScratchCardColorFactory::new();
    }
}
