<?php

namespace Albedo\ScratchCard\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ScratchCardTypeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'type' => $this->reason->slug,
            'label' => $this->reason->name,
            'color' => $this->color->name,
            'image' => $this->getFirstMediaUrl('image'),
            'quantity_to_win' => $this->target,
            'current_quantity' => $this->when(isset($this->current_quantity), fn() => $this->current_quantity),
        ];
    }
}
