<?php

namespace Albedo\ScratchCard\Http\Controllers;

use Albedo\ScratchCard\Enums\ScratchCardPrizeOrderStatus;
use Albedo\ScratchCard\Http\Requests\OrderAddressRequest;
use Albedo\ScratchCard\Models\ScratchCardEntry;
use Albedo\ScratchCard\Models\ScratchCardPrizeOrder;
use App\Http\Controllers\Controller;

class OrderAddressAction extends Controller
{
    /**
     * Order form
     * @authenticated
     * @group Scratch card
     */
    public function __invoke(ScratchCardEntry $scratchCardEntry, OrderAddressRequest $request)
    {
        try {
            ScratchCardPrizeOrder::create([
                'scratch_card_entry_id' => $scratchCardEntry->id,
                ...$request->validated()
            ]);
            $scratchCardEntry->update([
                'status' => ScratchCardPrizeOrderStatus::IN_VERIFICATION
            ]);
            return response()->success(message: __('Order successfully created.'));
        } catch (\Exception $e) {
            report($e);
            return response()->error(message: __('System error occurred.'));
        }
    }
}
