<?php

namespace Albedo\ScratchCard\Enums;

enum ScratchCardTypeEnum: string
{
    case DETAIL_CARD = 'detail_card';
    case BUSINESS_CARD = 'business_card';
    case DUEL = 'duel';

    public function label()
    {
        return match ($this) {
            self::BUSINESS_CARD => 'Złota zdrapka',
            self::DETAIL_CARD => 'Zielona zdrapka',
            self::DUEL => 'Czerwona zdrapka',
        };

    }

    public function name()
    {
        return match ($this) {
            self::BUSINESS_CARD => 'Sprzedane karty biznesowe',
            self::DETAIL_CARD => 'Sprzedane karty detaliczne',
            self::DUEL => 'Wygrane pojedynki wiedzowe',
        };

    }
}
