<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('gates', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(App\Models\User::class)->nullable();
            $table->morphs(\Albedo\ScratchCard\Models\Gate::PRIZE_MORPH_NAME);
            $table->string('name');
            $table->string('type');
            $table->dateTime('open_gate_at');
            $table->dateTime('close_gate_at');
            $table->dateTime('received')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('gates');
    }
};
