<?php

namespace Albedo\ScratchCard\Models;

use Albedo\ScratchCard\Exceptions\ConditionsNotAchievedException;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class ScratchCardResult extends Model
{
    use SoftDeletes;

    protected $guarded = [];

    protected $casts = [
        'used_at' => 'datetime'
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * @throws ConditionsNotAchievedException
     */
    public static function markScratchCardResultsForTargetUser(\App\Models\User $userModel, ScratchCardType $scratchCardTypeModel)
    {
        $scratchCardResults = ScratchCardResult::query()
            ->whereUserIdAndScratchCardTypeId($userModel->id, $scratchCardTypeModel->getKey())
            ->whereNull('used_at')
            ->limit($scratchCardTypeModel->target)
            ->get();

        if ($scratchCardResults->count() !== $scratchCardTypeModel->target) {
            throw new ConditionsNotAchievedException();
        }

        ScratchCardResult::query()
            ->whereIn('id', $scratchCardResults->pluck('id')->toArray())
            ->update([
                'used_at' => now(),
            ]);
    }

    public function scratchCardType(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(ScratchCardType::class);
    }

    public function source(): \Illuminate\Database\Eloquent\Relations\MorphTo
    {
        return $this->morphTo();
    }
}
