<?php

namespace Albedo\ScratchCard\Models;

use Albedo\ScratchCard\Database\factories\ScratchCardReasonFactory;
use Albedo\ScratchCard\Enums\ScratchCardReasonType;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ScratchCardReason extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'is_active' => 'boolean',
        'type' => ScratchCardReasonType::class,
    ];

    public function types(): HasMany
    {
        return $this->hasMany(ScratchCardType::class, 'scratch_card_reason_id');
    }

    /**
     * Create a new factory instance for the model.
     */
    protected static function newFactory(): Factory
    {
        return ScratchCardReasonFactory::new();
    }
}
