<?php

namespace Albedo\ScratchCard\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class OrderAddressRequest extends FormRequest
{
    public function rules(): array
    {
        $scratchCardEntry = $this->route('scratchCardEntry');

        if(!$scratchCardEntry){
            return [];
        }
        
        return $scratchCardEntry->scratchCardPrizeDraw->type_of_prize->requestRules();
    }

    public function authorize(): bool
    {
        return auth()->check();
    }
}
