<?php

namespace Albedo\ScratchCard\Http\Controllers;

use Albedo\Ranking\Exceptions\NoRankedShareException;
use Albedo\ScratchCard\Http\Resources\ScratchCardTypeResource;
use Albedo\ScratchCard\Services\UserScratchCardService;
use Illuminate\Routing\Controller as BaseController;

class TypesAction extends BaseController
{
    public function __construct(readonly protected UserScratchCardService $userScratchCardService)
    {

    }

    /**
     * Types
     * @authenticated
     * @group Scratch card
     */
    public function __invoke()
    {
        try {
            $types = $this->userScratchCardService->getTypesWithUser(auth()->user());

            return response()
                ->success(data: ScratchCardTypeResource::collection($types));
        } catch (\Exception $e) {
            report($e);
            return response()->error(message: __('System error occurred.'));
        }
    }
}
