<?php

namespace Albedo\ScratchCard\Enums;

use Illuminate\Routing\Exceptions\BackedEnumCaseNotFoundException;

enum TypeOfPrizeEnum: string
{
    case NORMAL = 'normal';

    case ELECTRONIC = 'electronic';

    case EMPTY = 'empty';

    public function requestRules(): array
    {
        return match ($this) {
            self::NORMAL => [
                'phone_number' => 'required|digits:9',
                'street' => 'required|min:1|max:255',
                'house_number' => 'required|min:1|max:255',
                'apartment_number' => 'present|max:255',
                'city' => 'required|min:1|max:255',
                'postal_code' => 'required|regex:/^\d{2}-\d{3}$/',
            ],
            self::ELECTRONIC => [
//               'email' => 'required|email:rfc,dns',
            ],
            self::EMPTY => [],
            default => throw new BackedEnumCaseNotFoundException($this::class, $this->value),
        };
    }

}
