<?php

use Albedo\ScratchCard\Models\ScratchCardType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('scratch_card_results', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(ScratchCardType::class)->constrained();
            $table->foreignIdFor(config('scratch-card.user_model'))->constrained();
            $table->morphs('source');
            $table->dateTime('used_at')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('scratch_card_results');
    }
};
