<?php

namespace Albedo\ScratchCard\Database\factories;

use Albedo\ScratchCard\Models\ScratchCardColor;
use Albedo\ScratchCard\Models\ScratchCardReason;
use Albedo\ScratchCard\Models\ScratchCardType;
use Illuminate\Database\Eloquent\Factories\Factory;
use Ramsey\Uuid\Uuid;

class ScratchCardTypeFactory extends Factory
{
    protected $model = ScratchCardType::class;

    public function definition(): array
    {
        $reason = ScratchCardReason::inRandomOrder()
            ->first();

        $color = ScratchCardColor::inRandomOrder()
            ->first();
        return [
            'name' => 'test',
            'scratch_card_reason_id' => $reason?->id ?? ScratchCardReason::factory(),
            'scratch_card_color_id' => $color?->id ?? ScratchCardColor::factory(),
            'target' => fake()->numberBetween(1, 10),
        ];
    }

    public function configure()
    {
        return $this->afterCreating(function (ScratchCardType $scratchCardType) {
            $scratchCardType->addMedia(self::image())
                ->toMediaCollection('image', 'public');
        });
    }

    public static function image(int $width = 640, int $height = 480)
    {
        $path = storage_path() . DIRECTORY_SEPARATOR . 'app' . DIRECTORY_SEPARATOR . Uuid::uuid1() . '.png';
        $im = imagecreate($width, $height);

        imagecolorallocate($im, rand(0, 255), rand(0, 255), rand(0, 255));
        imagepng($im, $path);

        return $path;
    }
}
