<?php

namespace Albedo\ScratchCard\Policies;

use Albedo\ScratchCard\Models\ScratchCardEntry;
use App\Models\Admin;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Container\Attributes\Auth;

class ScratchCardEntryPolicy
{
    use HandlesAuthorization;

    public function viewAny(User|Admin $user): bool
    {
        return $user instanceof Admin;
    }

    public function view(User|Admin $user, ScratchCardEntry $scratchCardEntry): bool
    {
        return $user->id === $scratchCardEntry->user_id || $user instanceof Admin;
    }

    public function create(User|Admin $user): bool
    {
        return false;
    }

    public function update(User|Admin $user, ScratchCardEntry $scratchCardEntry): bool
    {

        return $user->id === $scratchCardEntry->user_id || $user instanceof Admin;
    }

    public function delete(User|Admin $user, ScratchCardEntry $scratchCardEntry): bool
    {
        return false;
    }

    public function restore(User|Admin $user, ScratchCardEntry $scratchCardEntry): bool
    {
        return false;
    }

    public function forceDelete(User|Admin $user, ScratchCardEntry $scratchCardEntry): bool
    {
        return false;
    }
}
