<?php

namespace Albedo\ScratchCard\Models;

use Albedo\ScratchCard\Enums\OrderAddressStatus;
use Albedo\ScratchCard\Http\Controllers\OrderAddressAction;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ScratchCardPrizeOrder extends Model
{
    protected $guarded = [];

    protected $casts = [
        'used_at' => 'datetime',
    ];

    public function scratchCardEntry(): BelongsTo
    {
        return $this->belongsTo(ScratchCardEntry::class);
    }

    public function getAddress(): string
    {
        return $this->apartment_number ?
            ($this->street . ' ' . $this->house_number . '/' . $this->apartment_number) :
            ($this->street . ' ' . $this->house_number);
    }

}
