<?php

namespace Albedo\ScratchCard\Http\Resources;

use Albedo\ScratchCard\Enums\ScratchCardPrizeOrderStatus;
use Albedo\ScratchCard\Models\ScratchCardEntry;
use Albedo\ScratchCard\Models\ScratchCardPrizeOrder;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin ScratchCardEntry */
class ScratchCardEntryResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'drawn_at' => $this->drawn_at,
            'drawn_at_formatted' => $this->when(!is_null($this->drawn_at), fn() => $this->drawn_at?->format('d-m-Y') . 'r.'),
            'status' => [
                'name' => $this->status,
                'label' => $this->status->label(),
                'color' => $this->status->color(),
            ],
            'required_form_shipping' => $this->getRequiredFormShipping(),
            'completed_shipping' => $this->getCompletedShipping(),
            'scratched' => $this->scratched,
            'scratch_percentage' => $this->scratch_percentage,
            'scratch_card_prize_draw' => new ScratchCardPrizeDrawnResource($this->whenLoaded('scratchCardPrizeDraw')),

        ];
    }
}
