<?php

namespace Albedo\ScratchCard\Http\Resources;

use Albedo\ScratchCard\Models\Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin Gate */
class GateResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'open_gate_at' => $this->open_gate_at,
            'close_gate_at' => $this->close_gate_at,
            'used' => $this->used,

            'user_id' => $this->user_id,
        ];
    }
}
