<?php

namespace Albedo\ScratchCard\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class OrderScratchCardRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'scratch_card_type_id' => [
                'required',
                Rule::exists('scratch_card_types', 'id')
            ],
        ];
    }

    public function authorize(): bool
    {
        return auth()->check();
    }
}
