<?php

namespace Albedo\ScratchCard\Database\seeders;

use Albedo\ScratchCard\Models\Gate;
use Albedo\ScratchCard\Models\ScratchCardEntry;
use Albedo\ScratchCard\Models\ScratchCardGate;
use Carbon\CarbonPeriod;
use Illuminate\Database\Seeder;

class ScratchCardGateSeeder extends Seeder
{
    public function run(): void
    {
        ScratchCardEntry::all()
            ->each(fn(ScratchCardEntry $scratchCardEntry) => ScratchCardGate::createGate(
                'Bramka',
                CarbonPeriod::create(now(), now()->addYear()),
                $scratchCardEntry,
                $scratchCardEntry->scratchCardPrizeDraw->scratchCardType->reason,
            ));


    }
}
