<?php

use Albedo\ScratchCard\Models\ScratchCardGate;
use Albedo\ScratchCard\Models\ScratchCardReason;
use App\Models\User;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('scratch_card_gates', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(User::class)->nullable()->constrained();
            $table->foreignIdFor(ScratchCardReason::class)->nullable()->constrained();
            $table->morphs(ScratchCardGate::PRIZE_MORPH_NAME);
            $table->string('name');
            $table->dateTime('open_gate_at');
            $table->dateTime('close_gate_at');
            $table->dateTime('received')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('scratch_card_gates');
    }
};
