<?php

namespace Albedo\ScratchCard\Database\factories;

use Albedo\ScratchCard\Enums\ScratchCardReasonType;
use Albedo\ScratchCard\Models\ScratchCardReason;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class ScratchCardReasonFactory extends Factory
{
    protected $model = ScratchCardReason::class;

    public function definition(): array
    {
        return [
            'name' => $name = fake()->words(4, true),
            'slug' => Str::slug($name),
            'is_active' => fake()->boolean,
            'type' => fake()->randomElement(ScratchCardReasonType::cases()),
        ];
    }
}
