<?php

namespace Albedo\ScratchCard\Database\factories;

use Albedo\ScratchCard\Enums\ColorEnum;
use Albedo\ScratchCard\Models\ScratchCardColor;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class ScratchCardColorFactory extends Factory
{
    protected $model = ScratchCardColor::class;

    public function definition(): array
    {
        return [
            'name' => $name = fake()->colorName,
            'slug' => Str::slug($name),
            'is_active' => fake()->boolean,
        ];
    }
}
