<?php

namespace Albedo\ScratchCard\Models;

use Albedo\ScratchCard\Enums\TypeOfPrizeEnum;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Routing\Exceptions\BackedEnumCaseNotFoundException;

class ScratchCardPrizeDraw extends Model
{
    protected $guarded = [];

    protected $casts = [
        'type_of_prize' => TypeOfPrizeEnum::class,
    ];

    public function scratchCardType(): BelongsTo
    {
        return $this->belongsTo(ScratchCardType::class);
    }

    public function scratchCardEntries(): HasMany
    {
        return $this->hasMany(ScratchCardEntry::class);
    }

    public function getRequiredFormShipping(): bool
    {
        return match ($this->type_of_prize) {
            TypeOfPrizeEnum::NORMAL => true,
            TypeOfPrizeEnum::ELECTRONIC, TypeOfPrizeEnum::EMPTY => false,
            default => throw new BackedEnumCaseNotFoundException(TypeOfPrizeEnum::class, $this->value),
        };
    }
}
