<?php

namespace Albedo\ScratchCard\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderScratchCardResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'scratched' => $this->scratched,
            'scratch_percentage' => $this->scratch_percentage,
            'scratch_card_type' => new ScratchCardTypeResource($this->whenLoaded('scratchCardType')),
        ];
    }
}
