<?php

namespace Albedo\ScratchCard\Http\Controllers;

use Albedo\Ranking\Exceptions\NoRankedShareException;
use Albedo\ScratchCard\Contracts\LotteryDrawContract;
use Albedo\ScratchCard\Http\Resources\ScratchCardTypeResource;
use Albedo\ScratchCard\Models\ScratchCardResult;
use Albedo\ScratchCard\Models\ScratchCardType;
use Albedo\ScratchCard\Services\UserScratchCardService;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller as BaseController;
class TypesAction extends BaseController
{
    public function __construct(readonly protected UserScratchCardService $userScratchCardService)
    {

    }

    /**
     * Scratch card types
     *
     * @group Scratch card
     * @authenticated
     * @response 200 {"status": "OK", "data": [{"id": 1, "name": "Business Card", "type": "business_card", "color": "green", "image": "http:\/\/loc.2025-bps.test\/img\/scratch-card\/scratch-green.png", "quantity_to_win": 7, "current_quantity": 0}, {"id": 2, "name": "Detail Card", "type": "detail_card", "color": "gold", "image": "http:\/\/loc.2025-bps.test\/img\/scratch-card\/scratch-gold.png", "quantity_to_win": 7, "current_quantity": 1}, {"id": 3, "name": "Duel", "type": "duel", "color": "red", "image": "http:\/\/loc.2025-bps.test\/img\/scratch-card\/scratch-red.png", "quantity_to_win": 7, "current_quantity": 0}], "meta": [], "message": "", "errors": null}
     */
    public function __invoke(Request $request)
    {
        try {

            $types = $this->userScratchCardService->getTypesWithUser($request->user());

            return response()
                ->success(data: ScratchCardTypeResource::collection($types));
        } catch (\Exception $e) {
            report($e);
            return response()->error(message: __('System error occurred.'));
        }
    }
}
