<?php

namespace Albedo\ScratchCard\Http\Controllers;

use Albedo\ScratchCard\Http\Resources\ScratchCardEntryResource;
use Albedo\ScratchCard\Models\ScratchCardEntry;
use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class InfoScratchCardEntryAction extends Controller
{
    /**
     * Scratchcard details
     *
     * @group Scratch card
     * @authenticated
     * @response 200 {"status": "OK", "data": {"id": 17, "drawn_at": "2024-12-10T11:37:40.000000Z", "drawn_at_formatted": "10-12-2024r.", "status": "TODO", "scratched": 0, "scratch_percentage": 0}, "meta": [], "message": "Info of scratch card entry.", "errors": null}
     */
    public function __invoke(int $id)
    {
        /**
         * TODO Z jakiegoś powodu nie działa bindowanie po modelu.
         *      route api/screatch-cards/{scratchCardEntry} -> __invoke(ScratchCardEntry $scratchCardEntryId)
         *      zwraca pusty model dla zmniennej $scratchCardEntry.
         */

        $scratchCardEntry = ScratchCardEntry::query()
            ->whereUserId(auth()->id())
            ->whereId($id)
            ->with('scratchCardPrizeDraw')
            ->firstOrFail();


        Gate::authorize('view', $scratchCardEntry);

        try {
            return response()
                ->success(
                    message: __('Info of scratch card entry.'),
                    data: ScratchCardEntryResource::make($scratchCardEntry)
                );
        } catch (Exception $e) {
            return response()
                ->error(message: __('System error occurred.'));
        }
    }
}
