<?php

namespace Albedo\ScratchCard\Http\Controllers;

use Albedo\ScratchCard\Http\Resources\ScratchCardEntryResource;
use Albedo\ScratchCard\Models\ScratchCardEntry;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller as BaseController;

class HistoryAction extends BaseController
{
    /**
     * Scratch card history
     *
     * @group Scratch card
     * @authenticated
     * @response 200 {"status": "OK", "data": [{"id": 5, "drawn_at": "2024-12-10T11:59:20.000000Z", "drawn_at_formatted": "10-12-2024r.", "status": "TODO", "scratched": 0, "scratch_percentage": 0, "scratch_card_prize_draw": {"id": 1, "name": "test", "image": "", "type_of_prize": "normal"}}, {"id": 17, "drawn_at": "2024-12-10T11:37:40.000000Z", "drawn_at_formatted": "10-12-2024r.", "status": "TODO", "scratched": 0, "scratch_percentage": 0, "scratch_card_prize_draw": {"id": 2, "name": "test", "image": "", "type_of_prize": "normal"}}], "meta": [], "message": "History of scratch cards.", "errors": null}
     */
    public function __invoke(Request $request)
    {
        try {
            $scratchCardEntriesCollection = ScratchCardEntry::query()
                ->with('scratchCardPrizeDraw.scratchCardType')
                ->whereUserId($request->user()->id)
                ->orderBy('drawn_at', 'desc')
                ->get();

            return response()->success(
                message: __('History of scratch cards.'),
                data: ScratchCardEntryResource::collection($scratchCardEntriesCollection)
            );
        } catch (\Exception $e) {
            report($e);
            return response()->error(message: 'System error occurred.');
        }

    }

}
