<?php

namespace Albedo\ScratchCard;

use Albedo\ScratchCard\Contracts\LotteryDrawContract;
use Albedo\ScratchCard\Contracts\PrizeContract;
use Albedo\ScratchCard\Enums\ScratchCardTypeEnum;
use Albedo\ScratchCard\Models\Gate;
use Albedo\ScratchCard\Services\ScratchCardPrizeService;

class GateLotteryByScratchCardTypeGenerator implements LotteryDrawContract
{
    public function __construct(protected ScratchCardTypeEnum $type)
    {
    }

    public function drawPrize(): PrizeContract
    {
        $prize = Gate::draw($this->type);

        if (is_null($prize)){
            $prize = ScratchCardPrizeService::getEmptyPrize($this->type);
        }

        return $prize;
    }

}
