<?php

namespace Albedo\ScratchCard\Enums;

use Exception;

enum ScratchCardPrizeOrderStatus: string
{
    case NO_DATA = 'no_data';
    case IN_VERIFICATION = 'in_verification';
    case NEEDS_CORRECTION = 'needs_correction';
    case APPROVED = 'approved';
    case PRIZE_ISSUED = 'prize_issued';
    case REJECTED = 'rejected';

    public function label(): string
    {
        return match ($this) {
            self::NO_DATA => 'Brak danych karty',
            self::IN_VERIFICATION => 'Trwa weryfikacja',
            self::NEEDS_CORRECTION => 'Kontakt z organizatorem',
            self::APPROVED => 'Zaakceptowane',
            self::PRIZE_ISSUED => 'Nagroda otrzymana',
            self::REJECTED => 'Odrzucone',
        };
    }

    public function color(): string
    {
        return match ($this) {
            self::NO_DATA => 'error',
            self::IN_VERIFICATION => 'pending',
            self::NEEDS_CORRECTION => 'error',
            self::APPROVED => 'success',
            self::PRIZE_ISSUED => 'success',
            self::REJECTED => 'error',
        };
    }

    public static function tryFromTranslation(string $from): ScratchCardPrizeOrderStatus
    {
        return match ($from) {
            'Brak danych karty' => self::NO_DATA,
            'Trwa weryfikacja' => self::IN_VERIFICATION,
            'Kontakt z organizatorem' => self::NEEDS_CORRECTION,
            'Zaakceptowane' => self::APPROVED,
            'Nagroda otrzymana' => self::PRIZE_ISSUED,
            'Odrzucone' => self::REJECTED,
            default => new Exception('Niepoprawny status zdrapki'),
        };
    }
}
