<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('scratch_card_prize_draws', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(\Albedo\ScratchCard\Models\ScratchCardType::class)->constrained();
            $table->string('name');
            $table->text('image');
            $table->integer('amount');
            $table->string('type_of_prize');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('scratch_card_prize_draws');
    }
};
