<?php

namespace Albedo\ScratchCard\Database\factories;

use Albedo\ScratchCard\Enums\ColorEnum;
use Albedo\ScratchCard\Enums\ScratchCardTypeEnum;
use Albedo\ScratchCard\Models\ScratchCardType;
use Illuminate\Database\Eloquent\Factories\Factory;

class ScratchCardTypeFactory extends Factory
{
    protected $model = ScratchCardType::class;

    public function definition(): array
    {
        return [
            'name' => 'test',
            'type' => fake()->randomElement(ScratchCardTypeEnum::cases()),
            'color' => fake()->randomElement(ColorEnum::cases()),
            'target' => fake()->numberBetween(1, 10),
            'image' => '',
        ];
    }
}
