<?php

use Albedo\ScratchCard\Dtos\ScratchCardPrizeDto;
use Albedo\ScratchCard\Enums\ColorEnum;
use Albedo\ScratchCard\Enums\ScratchCardTypeEnum;
use Albedo\ScratchCard\Enums\TypeOfPrizeEnum;
use Albedo\ScratchCard\Models\ScratchCardType;
use Albedo\ScratchCard\Services\ScratchCardPrizeService;
use Albedo\ScratchCard\Services\UserScratchCardService;
use App\Models\User;
use function Pest\Laravel\postJson;
use function PHPUnit\Framework\assertTrue;

it('can order scratch card', function () {

    $scratchCardType = ScratchCardType::factory()->create();

    return;

    collect($scratchCardTypes)
        ->each(fn($scratchCardType) => ScratchCardType::updateOrCreate([
            'name' => $scratchCardType['name']
        ], [
            'type' => $scratchCardType['type'],
            'color' => $scratchCardType['color'],
            'target' => 7,
            'image' => url($scratchCardType['image']),
        ]));

    $scratchCardTypeModels = ScratchCardType::all();
    $typeOfPrizeEnums = TypeOfPrizeEnum::NORMAL;
    $amount = 5;

    $scratchCardTypeModels
        ->each(function (ScratchCardType $scratchCardTypeModel) use ($typeOfPrizeEnum, $amount) {
            app(ScratchCardPrizeService::class)
                ->addPrize(
                    ScratchCardPrizeDto::create('test', $amount, ''),
                    $scratchCardTypeModel,
                    $typeOfPrizeEnum,
                );
        });

    (new UserScratchCardService())->addScratchCardResult(
        $user = User::firstOrFail(),
        ScratchCardTypeEnum::BUSINESS_CARD,
        $user,
    );

});
