<?php

namespace Albedo\ScratchCard;

use Albedo\ScratchCard\Console\Commands\AddPrizeScratchCardCommand;
use Albedo\ScratchCard\Console\Commands\AddScratchCardCommand;
use Albedo\ScratchCard\Console\Commands\DevCommand;
use Albedo\ScratchCard\Console\Commands\InitScratchCardCommand;
use Albedo\ScratchCard\Console\Commands\ScratchCardSeederCommand;
use Albedo\ScratchCard\Contracts\PrizeGeneratorContract;
use Albedo\ScratchCard\Models\ScratchCardEntry;
use Illuminate\Support\Facades\Route;
use Spatie\LaravelPackageTools\Commands\InstallCommand;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class ScratchCardProvider extends PackageServiceProvider
{
    public static string $name = 'scratch-card';

    public function boot(): void
    {
        parent::boot();
    }

    public function configurePackage(Package $package): void
    {
        $package->name(static::$name)
            ->hasConfigFile()
            ->hasRoute('api')
            ->hasCommands([
                ScratchCardSeederCommand::class,
            ])
            ->hasMigrations([
                '2024_11_21_105546_create_scratch_card_colors_table',
                '2024_11_21_105546_create_scratch_card_reasons_table',
                '2024_11_21_115546_create_scratch_card_types_table',
                '2024_11_21_115558_create_scratch_card_results_table',
                '2024_11_21_115625_create_scratch_card_entries_table',
                '2024_11_21_115608_create_scratch_card_prize_draws_table',
                '2024_11_21_115637_create_scratch_card_prize_orders_table',
                '2024_12_19_093559_create_scratch_card_gates_table',
                '2025_01_31_105625_update_scratch_card_entries_table',
            ])
            ->runsMigrations()
            ->hasInstallCommand(function (InstallCommand $command) {
                $command
                    ->publishConfigFile()
                    ->publishAssets()
                    ->publishMigrations()
                    ->copyAndRegisterServiceProviderInApp();
            });
    }
}
