<?php

namespace Albedo\ScratchCard\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

class UpdateScratchCardRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'scratched' => 'required|boolean',
            'scratch_percentage' => 'required|numeric|min:0|max:100',
        ];
    }

    public function authorize(): bool
    {
        return auth()->check();
    }
}
