<?php

namespace Albedo\ScratchCard\Http\Controllers;

use Albedo\ScratchCard\Http\Requests\UpdateScratchCardRequest;
use Albedo\ScratchCard\Models\ScratchCardEntry;
use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Support\Facades\Gate;

class UpdateScratchCardEntryAction extends Controller
{
    /**
     * Update scratch card status
     * @authenticated
     * @group Scratch card
     */
    public function __invoke(ScratchCardEntry $scratchCardEntry, UpdateScratchCardRequest $request)
    {
        Gate::authorize('update', $scratchCardEntry);

        try {
            if (is_null($scratchCardEntry->scratched_at) && $request->scratched) {
                $scratchCardEntry->update([
                    'scratched_at' => now(),
                ]);
            }

            $scratchCardEntry->update([
                'scratched' => max($scratchCardEntry->scratched, $request->scratched),
                'scratch_percentage' => max($scratchCardEntry->scratch_percentage, $request->scratch_percentage)
            ]);

            return response()
                ->success(message: __('Scratch card status updated.'));
        } catch (Exception) {
            return response()
                ->error(message: __('System error occurred.'));
        }

    }
}
