<?php

namespace Albedo\ScratchCard\Http\Controllers;

use Albedo\ScratchCard\Enums\ScratchCardPrizeOrderStatus;
use Albedo\ScratchCard\Http\Requests\OrderAddressRequest;
use Albedo\ScratchCard\Models\ScratchCardEntry;
use Albedo\ScratchCard\Models\ScratchCardPrizeOrder;
use App\Http\Controllers\Controller;

class OrderAddressAction extends Controller
{
    /**
     * Order form
     * @authenticated
     * @group Scratch card
     *
     * @bodyParam phone_number string required Example: 123456789
     * @bodyParam street string required Example: ul. Marszałkowska
     * @bodyParam house_number string required Example: 12
     * @bodyParam apartment_number string nullable Example: 3A
     * @bodyParam city string required Example: Warszawa
     * @bodyParam postal_code string required Example: 00-001
     */
    public function __invoke(ScratchCardEntry $scratchCardEntry, OrderAddressRequest $request)
    {
        try {
            ScratchCardPrizeOrder::create([
                'scratch_card_entry_id' => $scratchCardEntry->id,
                ...$request->validated()
            ]);
            $scratchCardEntry->update([
                'status' => ScratchCardPrizeOrderStatus::IN_VERIFICATION
            ]);
            return response()->success(message: __('Order successfully created.'));
        } catch (\Exception $e) {
            report($e);
            return response()->error(message: __('System error occurred.'));
        }
    }
}
